<?php

use App\Http\Controllers\ApplyController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\InitLoadingController;
use App\Http\Controllers\JobController;
use App\Http\Controllers\MembershipController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\ProfileController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::post('check/payTR/payment/wptjo2grqbbi2hydrhm9iwkd5r8wfuqavtf','PaymentController@checkPayTRPayment');


// Start Auth Controller
Route::get('check-token',[AuthController::class,'checkToken']);
Route::post('signup',[AuthController::class,'signup']);
Route::post('forgot-password',[AuthController::class,'forgotPassword']);
Route::post('login',[AuthController::class,'login']);
Route::post('otp-submit',[AuthController::class,'otpSubmit']);
Route::post('new-otp',[AuthController::class,'newOtp']);
// End Auth Controller

Route::get('get/aggrements/{id}',[InitLoadingController::class,'getAggrements']);
Route::get('get/onboarding',[InitLoadingController::class,'getOnboardingScreens']);




//Route::get('get/landing','ApiController@getLanding');

Route::group(['middleware' => 'checkApi'], function(){
  Route::get('get/job-list',[JobController::class,'getJobList']);
  Route::group(['prefix'=>'profile'],function(){
    Route::get('my',[ProfileController::class,'profile']);
    Route::get('to/{id}',[ProfileController::class,'getPreProfile']);
    Route::post('update',[ProfileController::class,'profileUpdate']);
    Route::post('completed',[ProfileController::class,'profileCompletedEmployer']);
    Route::post('photo-update',[ProfileController::class,'profilePhotoUpdate']);
    Route::post('video-update',[ProfileController::class,'profileVideoUpdate']);
    Route::post('password/update',[ProfileController::class,'profilePasswordUpdate']);
    Route::post('delete-account',[ProfileController::class,'profileDeleteAccount']);
  });
  // Experience Controller
  Route::group(['prefix'=>'experience'],function(){
    Route::post('create',[JobController::class,'createJobExperience']);
    Route::post('update',[JobController::class,'updateJobExperience']);
    Route::get('delete/{id}',[JobController::class,'deleteJobExperience']);
    Route::get('list',[JobController::class,'listJobExperience']);
  });
  // Post Controller
  Route::group(['prefix'=>'post'],function(){
    Route::post('create',[PostController::class,'createPost']);
    Route::post('update',[PostController::class,'updatePost']);
    Route::get('delete/{id}',[PostController::class,'deletePost']);
    Route::get('reject/{id}',[PostController::class,'rejectPost']);
    Route::get('list/own/post',[PostController::class,'ownPost']);
    Route::get('list/{type}',[PostController::class,'listPost']);
    Route::get('list-by-cat/{platform}/{type}',[PostController::class,'listPostByCat']);
    Route::get('detail/{id}',[PostController::class,'detailPost']);
    //Route::get('example-video/{id}',[PostController::class,'getExampleVideo']);
    //Route::get('upload/example-video',[PostController::class,'uploadExampleVideo']);

    Route::post('apply',[ApplyController::class,'setApply']);
    Route::get('apply/{postId}/{applicationId}/{process}',[ApplyController::class,'processApply']);
    Route::get('employer/apply/list/{postId}/{type}',[ApplyController::class,'listApplyEmployer']);
   //Route::get('apply/detail/{id}',[ApplyController::class,'getApply']);

    Route::get('worker/apply/list/{type}',[ApplyController::class,'listApplyWorker']);
    Route::get('worker/apply/cancel/{id}',[ApplyController::class,'cancelApplyWorker']);
  });


  // Membership Controller
  Route::group(['prefix'=>'membership'],function(){
    Route::get('plans',[ApplyController::class,'getMembershipPlans']);
    Route::get('plan/{planId}',[ApplyController::class,'getMembershipPlan']);
    Route::get('buy/plan/{planId}',[ApplyController::class,'buyMembershipPlan']);
    Route::get('history',[ApplyController::class,'membershipCreditHistory']);
  });

 // Stories Controller
  Route::group(['prefix'=>'stories'],function(){
    Route::post('create',[MembershipController::class,'uploadStory']);
    Route::get('view/{storyId}',[ApplyController::class,'getStory']);
    Route::get('delete/{storyId}',[ApplyController::class,'deleteStory']);
    Route::get('list',[ApplyController::class,'getStories']);
  });


  Route::group(['prefix'=>'expense'],function(){
    Route::get('pay/profile/{workerId}',[ExpenseController::class,'payForViewProfile']);
  });

});

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
