<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use TCG\Voyager\Models\DataType;

class DataTypesTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        DataType::truncate();

        DataType::insert(array (
            array (
                'id' => 1,
                'name' => 'users',
                'slug' => 'users',
                'display_name_singular' => 'User',
                'display_name_plural' => 'Users',
                'icon' => 'voyager-person',
                'model_name' => 'TCG\\Voyager\\Models\\User',
                'policy_name' => 'TCG\\Voyager\\Policies\\UserPolicy',
                'controller' => 'TCG\\Voyager\\Http\\Controllers\\VoyagerUserController',
                'description' => '',
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => NULL,
                'created_at' => '2022-04-20 21:59:52',
                'updated_at' => '2022-04-20 21:59:52',
            ),
            array (
                'id' => 2,
                'name' => 'menus',
                'slug' => 'menus',
                'display_name_singular' => 'Menu',
                'display_name_plural' => 'Menus',
                'icon' => 'voyager-list',
                'model_name' => 'TCG\\Voyager\\Models\\Menu',
                'policy_name' => NULL,
                'controller' => '',
                'description' => '',
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => NULL,
                'created_at' => '2022-04-20 21:59:52',
                'updated_at' => '2022-04-20 21:59:52',
            ),
            array (
                'id' => 3,
                'name' => 'roles',
                'slug' => 'roles',
                'display_name_singular' => 'Role',
                'display_name_plural' => 'Roles',
                'icon' => 'voyager-lock',
                'model_name' => 'TCG\\Voyager\\Models\\Role',
                'policy_name' => NULL,
                'controller' => 'TCG\\Voyager\\Http\\Controllers\\VoyagerRoleController',
                'description' => '',
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => NULL,
                'created_at' => '2022-04-20 21:59:52',
                'updated_at' => '2022-04-20 21:59:52',
            ),
            array (
                'id' => 4,
                'name' => 'members',
                'slug' => 'members',
                'display_name_singular' => 'Kullanıcı',
                'display_name_plural' => 'Kullanıcılar',
                'icon' => 'voyager-people',
                'model_name' => 'App\\Member',
                'policy_name' => NULL,
                'controller' => NULL,
                'description' => NULL,
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => '{"order_column":null,"order_display_column":null,"order_direction":"asc","default_search_key":null,"scope":null}',
                'created_at' => '2022-04-22 10:22:52',
                'updated_at' => '2022-04-22 17:45:40',
            ),
            array (
                'id' => 5,
                'name' => 'c_aggrements',
                'slug' => 'c-aggrements',
                'display_name_singular' => 'Sözleşme',
                'display_name_plural' => 'Sözleşmeler',
                'icon' => 'voyager-news',
                'model_name' => 'App\\CAggrement',
                'policy_name' => NULL,
                'controller' => NULL,
                'description' => NULL,
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => '{"order_column":null,"order_display_column":null,"order_direction":"asc","default_search_key":null}',
                'created_at' => '2022-04-22 16:38:08',
                'updated_at' => '2022-04-22 16:38:08',
            ),
            array (
                'id' => 6,
                'name' => 'c_jobs',
                'slug' => 'c-jobs',
                'display_name_singular' => 'Meslek',
                'display_name_plural' => 'Meslekler',
                'icon' => 'voyager-list',
                'model_name' => 'App\\CJob',
                'policy_name' => NULL,
                'controller' => NULL,
                'description' => NULL,
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => '{"order_column":null,"order_display_column":null,"order_direction":"asc","default_search_key":null}',
                'created_at' => '2022-04-22 16:41:02',
                'updated_at' => '2022-04-22 16:41:02',
            ),
            array (
                'id' => 7,
                'name' => 'c_example_videos',
                'slug' => 'c-example-videos',
                'display_name_singular' => 'Örnek Video',
                'display_name_plural' => 'Örnek Videolar',
                'icon' => 'voyager-youtube-play',
                'model_name' => 'App\\CExampleVideo',
                'policy_name' => NULL,
                'controller' => NULL,
                'description' => NULL,
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => '{"order_column":null,"order_display_column":null,"order_direction":"asc","default_search_key":null,"scope":null}',
                'created_at' => '2022-04-22 17:01:00',
                'updated_at' => '2022-06-25 07:36:28',
            ),
            array (
                'id' => 9,
                'name' => 'membership_plans',
                'slug' => 'membership-plans',
                'display_name_singular' => 'Üyelik Planı',
                'display_name_plural' => 'Üyelik Planları',
                'icon' => 'voyager-params',
                'model_name' => 'App\\MembershipPlan',
                'policy_name' => NULL,
                'controller' => NULL,
                'description' => NULL,
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => '{"order_column":null,"order_display_column":null,"order_direction":"asc","default_search_key":null,"scope":null}',
                'created_at' => '2022-04-25 00:42:50',
                'updated_at' => '2022-06-25 11:15:54',
            ),
            array (
                'id' => 10,
                'name' => 'memberships',
                'slug' => 'memberships',
                'display_name_singular' => 'Satın Alma',
                'display_name_plural' => 'Satın Almalar',
                'icon' => 'voyager-ticket',
                'model_name' => 'App\\Membership',
                'policy_name' => NULL,
                'controller' => NULL,
                'description' => NULL,
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => '{"order_column":null,"order_display_column":null,"order_direction":"asc","default_search_key":null,"scope":null}',
                'created_at' => '2022-04-25 00:48:58',
                'updated_at' => '2022-04-25 00:56:14',
            ),
            array (
                'id' => 15,
                'name' => 'posts',
                'slug' => 'posts',
                'display_name_singular' => 'Post',
                'display_name_plural' => 'Posts',
                'icon' => NULL,
                'model_name' => 'App\\Post',
                'policy_name' => NULL,
                'controller' => NULL,
                'description' => NULL,
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => '{"order_column":null,"order_display_column":null,"order_direction":"asc","default_search_key":null}',
                'created_at' => '2022-08-29 08:57:05',
                'updated_at' => '2022-08-29 08:57:05',
            ),
            array (
                'id' => 17,
                'name' => 'postxes',
                'slug' => 'postxes',
                'display_name_singular' => 'İlan',
                'display_name_plural' => 'İlanlar',
                'icon' => 'voyager-calendar',
                'model_name' => 'App\\Postx',
                'policy_name' => NULL,
                'controller' => NULL,
                'description' => NULL,
                'generate_permissions' => 1,
                'server_side' => 0,
                'details' => '{"order_column":null,"order_display_column":null,"order_direction":"asc","default_search_key":null,"scope":null}',
                'created_at' => '2022-08-29 09:01:11',
                'updated_at' => '2022-08-29 16:29:32',
            ),
        ));


    }
}
