<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('postxes', function (Blueprint $table) {
            $table->id();
            $table->integer('member_id');
            $table->text('title')->nullable();
            $table->integer('job_id');
            $table->dateTime('date');
            $table->text('about')->nullable();
            $table->string('location', 250)->nullable();
            $table->text('example_video_link')->nullable();
            $table->text('example_photo_link')->nullable();
            $table->string('created_ip', 50)->nullable();
            $table->string('active', 1)->nullable()->default('0');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('postxes');
    }
};
