<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('membership_payments', function (Blueprint $table) {
            $table->id();
            $table->integer('member_id')->nullable();
            $table->integer('plan_id')->nullable();
            $table->string('order_id', 60)->nullable();
            $table->string('credit', 10)->nullable();
            $table->decimal('amount', 10, 0)->nullable();
            $table->string('status', 1)->nullable()->default('1');
            $table->longText('reject_reason')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('membership_payments');
    }
};
