<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_stories', function (Blueprint $table) {
            $table->id();
            $table->integer('member_id')->nullable();
            $table->text('video_link')->nullable();
            $table->string('active', 1)->nullable()->default('1');
            $table->string('created_ip', 50)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_stories');
    }
};
