<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_experiences', function (Blueprint $table) {
            $table->id();
            $table->integer('member_id')->nullable();
            $table->string('company', 250)->nullable();
            $table->integer('job_id')->nullable();
            $table->string('duration', 50)->nullable();
            $table->string('created_ip', 50)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_experiences');
    }
};
