<?php

namespace App\Http\Controllers;

use App\MemberStory;
use App\Outsource;
use App\PostApplication;
use App\Postx;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

class StoryController extends Controller
{
    public function processApply(Request $request,$postId,$applicationId,$process)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

        $checkPost = Postx::where('id',$postId)->where('member_id',$check)->count();
        if($checkPost>0)
        {

          // process => approve - reject
          if($process == 'approved')
          {
            $update = PostApplication::where('id',$applicationId)
                                      ->update([
                                        'approved_at'=>date('Y-m-d H:i:s'),
                                        'approved_ip'=>$_SERVER['REMOTE_ADDR']
                                      ]);

            return response()->json(array('status'=>true,'message'=>'İlan başvurusu onaylanmıştır.'));

          }elseif($process=='reject'){

              $update = PostApplication::where('id',$applicationId)
                                        ->update([
                                          'rejected_at'=>date('Y-m-d H:i:s'),
                                          'rejected_ip'=>$_SERVER['REMOTE_ADDR']
                                        ]);
              return response()->json(array('status'=>true,'message'=>'İlan başvurusu reddedilmiştir.'));
          }

        }else{
          return response()->json(array('status'=>false,'message'=>'Bu ilan size ait değildir.'));
        }


      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function getStories(Request $request)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {


      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function getStory(Request $request,$storyId)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

        $list = MemberStory::where('id',$storyId)->whereNull('deleted_at')->where('active','1')->first();
        if(isset($list->id))
        {
          return response()->json(array('status'=>true,'message'=>'Kişinin profil videosu getirildi.','data'=>$list));
        }else{
          return response()->json(array('status'=>false,'message'=>'İçeriğe ulaşılamıyor.'));
        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function uploadStory(Request $request)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
        $validator = Validator::make($request->all(),
        [
          'video_link' => 'required'
        ],[
          'required' => '* Gerekli alan'
        ]);
        if ($validator->fails()) {
          return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        }else{
          $request->request->add(['member_id' => $check,'created_ip'=>$_SERVER['REMOTE_ADDR']]);
          $input = $request->all();
          $date = date('Y-m-d H:i:s');
          // Önceki Storylerin silinmesi işlemi
          $delete = MemberStory::where('member_id',$check)->update(['active'=>'0','deleted_at'=>$date]);
          $insert = MemberStory::insert($input);
          return response()->json(array('status'=>true,'message'=>'Profil Videonuz başarıyla yüklenmiştir.'));
        }
      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function deleteStory(Request $request,$storyId)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
        // Kişiye Ait Storyler silinecek
          if(is_numeric($storyId))
          {
            $delete = MemberStory::where('id',$storyId)->update([
              'active'=>'0',
              'deleted_at'=>date('Y-m-d H:i:s')
            ]);
            return response()->json(array('status'=>true,'message'=>'Profil videosu başarıyla silinmiştir.'));
          }
      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

}
