<?php

namespace App\Http\Controllers;

use App\MemberProfile;
use App\MemberStory;
use Illuminate\Http\Request;
use App\Outsource;
use App\PostApplication;
use App\Postx;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Validator;

class PostController extends Controller
{

    public function createPost(Request $request)
    {

      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
        $validator = Validator::make($request->all(),
        [
          'title' => 'required',
          'job_id' => 'required',
          'about' => 'required',
          'example_video_link' => 'required'
        ],[
          'required' => '* Gerekli alan'
        ]);

        if ($validator->fails()) {
          return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        }else{
          $last_at= strtotime('+30 day',strtotime(date('Y-m-d')));
          $last = date('Y-m-d',$last_at);
          $request->request->add(['date'=>$last,'member_id' => $check,'created_ip'=>$_SERVER['REMOTE_ADDR']]);
          $input = $request->all();

          $expense = Outsource::expenseCredit($check,'create_ad');
          if($expense)
          {
            $insert = Postx::insert($input);
            return response()->json(array('status'=>true,'message'=>'İlanınız oluşturuldu, yönetici onayı sonrası yayınlanacaktır.'));
          }else{
            return response()->json(array('status'=>false,'message'=>'Sistem kredi harcama onayını alamadı, lütfen kredi bakiyenizi kontrol ediniz.'));
          }

        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }

    }

    public function updatePost(Request $request)
    {

      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
        $validator = Validator::make($request->all(),
        [
          'id' => 'required',
          'member_id' => 'required',
          'title' => 'required',
          'job_id' => 'required',
          'date' => 'required',
          'about' => 'required',
          'example_video_link' => 'required'
        ],[
          'required' => '* Gerekli alan'
        ]);

        if ($validator->fails()) {
          return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        }else{

          $input = $request->all();

          $update = Postx::where('id',$request->get('id'))->update($input);

          return response()->json(array('status'=>true,'message'=>'İlanınız güncellendi, yönetici onayı sonrası yayınlanacaktır.'));

        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }

    }

    public function deletePost(Request $request,$id)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

        if(is_numeric($id))
        {
          $delete = Postx::where('id',$id)->update([
            'deleted_at'=>date('Y-m-d H:i:s')
          ]);

          return response()->json(array('status'=>true,'message'=>'İlanınız başarıyla silinmiştir.'));
        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }


    public function rejectPost(Request $request,$id)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

        if(is_numeric($id))
        {
          $reject = Postx::where('id',$id)->update([
            'active'=>'0',
            'deleted_at'=>date('Y-m-d H:i:s')
          ]);

          return response()->json(array('status'=>true,'message'=>'İlanınız başarıyla pasife alınmıştır.'));
        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }


    public function detailPost(Request $request,$id)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
          $data = Postx::where('id',$id)->first();

          $video = $data->example_video_link;
          $video_link = $video;
          $company = Outsource::getCompanyDetail($data->member_id);
          $company_profile = MemberProfile::where('member_id',$company->id)->first();
          $exp_loc = explode(',',$data->location);

          $applyCount = PostApplication::where('post_id',$id)->where('creator_id',$check)->count();

          $result = array('id'=>$data->id,
                          'company_title'=>$company->company_title,
                          'title'=>$data->title,
                          'about'=>$data->about,
                          'work_date'=>date('d.m.Y H:i',strtotime($data->date)),
                          'job'=>Outsource::getJobDetail($data->job_id)->value,
                          'video_link'=>$video_link,
                          'loc'=>$data->location,
                        'lat'=>$exp_loc[0],
                      'lng'=>$exp_loc[1],
                    'applyCount'=>$applyCount);

          return response()->json(array('status'=>true,'message'=>'İlan detayı getirildi.','result'=>$result));
      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function ownPost(Request $request)
    {
      $token = $request->header('token');


      $check = Outsource::checkToken($token);
      if($check)
      {

        $list = DB::table('postxes')
                    ->where('member_id',$check)
                    ->whereNull('deleted_at')
                    ->orderBy('id','DESC')
                    ->get();

        $result = [];

        foreach($list as $key=>$li)
        {
          $result[$key]['id'] = $li->id;
          $result[$key]['title'] = $li->title;
          $result[$key]['job_id'] = $li->job_id;
          $result[$key]['job_title'] = Outsource::getJobDetail($li->job_id)->value;
          $result[$key]['about'] = $li->about;
          $result[$key]['active'] = $li->active;
        }

        return response()->json(array('status'=>true,'message'=>'İlanların listesi getirildi.','result'=>$result));

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function listPost(Request $request,$type)
    {
        $token = $request->header('token');
        $check = Outsource::checkToken($token);
        if($check)
        {

          if($type=='job'){
            $workerProfile = MemberProfile::where('member_id',$check)->first();
            $data = Postx::where('job_id',$workerProfile->job_id)->where('active','1')->whereNull('deleted_at')->get();

            $result = array();
            foreach($data as $key=>$d)
            {
              $profile = Outsource::getCompanyDetail($d->member_id);
              $detail = MemberProfile::where('member_id',$profile->id)->first();

              $result[$key]['id']=$d->id;
              $result[$key]['company_title']=$profile->company_title;
              $result[$key]['title']=$d->title;
              $result[$key]['about']=$d->about;
              $result[$key]['profile_photo']=@$detail->photo_link;
              $result[$key]['example_photo_link']='https://visivi.agenti.com.tr/api/public//storage/'.$d->example_photo_link;
              $result[$key]['example_video_link']=$d->example_video_link;
              @$result[$key]['distance']=Outsource::haversineDistance($workerProfile->loc_lat,$workerProfile->loc_lng,$detail->loc_lat,$detail->loc_lng);
            }

            return response()->json(array('status'=>true,'message'=>'İlan listesi getirildi.','result'=>$result));
          }elseif($type=='company'){
            $data = MemberStory::where('active','1')->whereNull('deleted_at')->orderBy('id','desc')->get();

            $result = array();
            foreach($data as $key=>$d)
            {
              $profile = Outsource::getCompanyDetail($d->member_id);
              $workerProfile = MemberProfile::where('member_id',$d->member_id)->first();
              $me = MemberProfile::where('member_id',$check)->first();
              $detail = MemberProfile::where('member_id',$profile->id)->first();

              $result[$key]['id'] = $d->id;
              $result[$key]['member_id'] = $d->member_id;
              $result[$key]['member_name'] = $profile->firstname . ' '. $profile->surname;

              @$result[$key]['title'] = Outsource::getJobDetail($detail->job_id)->value;
              $result[$key]['about'] = $detail->about;
              $result[$key]['profile_photo'] = $detail->photo_link;
              $result[$key]['example_video_link'] = $d->video_link;
              @$result[$key]['distance']=Outsource::haversineDistance($workerProfile->loc_lat,$workerProfile->loc_lng,$me->loc_lat,$me->loc_lng);
            }


            return response()->json(array('status'=>true,'message'=>'İlan listesi getirildi.','result'=>$result));
          }

        }else{
          return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
        }
    }
    public function listPostByCat(Request $request,$platform,$type)
  {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

        if($platform=='job'){
          $workerProfile = MemberProfile::where('member_id',$check)->first();
          $data = Postx::where('job_id',$type)->where('active','1')->whereNull('deleted_at')->get();

          $result = array();
          foreach($data as $key=>$d)
          {
            $profile = Outsource::getCompanyDetail($d->member_id);
            $detail = MemberProfile::where('member_id',$profile->id)->first();

            $result[$key]['id'] = $d->id;
            $result[$key]['company_title'] = $profile->company_title;
            $result[$key]['title'] = $d->title;
            $result[$key]['about'] = $d->about;
            $result[$key]['profile_photo'] = @$detail->photo_link;
            $result[$key]['example_photo_link']='https://visivi.agenti.com.tr/api/public//storage/'.$d->example_photo_link;
            $result[$key]['example_video_link'] = $d->example_video_link;
            @$result[$key]['distance']=Outsource::haversineDistance($workerProfile->loc_lat,$workerProfile->loc_lng,$detail->loc_lat,$detail->loc_lng);
          }

          return response()->json(array('status'=>true,'message'=>'İlan listesi getirildi.','result'=>$result));
        }elseif($platform=='company'){

          $data = MemberProfile::where('job_id',$type)->whereNull('deleted_at')->get();

          $result = array();
          foreach($data as $key=>$d)
          {
              $story = MemberStory::where('member_id',$d->member_id)->where('active','1')->whereNull('deleted_at')->first();
              $profile = Outsource::getCompanyDetail($d->member_id);
              $detail = MemberProfile::where('member_id',$profile->id)->first();
              $me = MemberProfile::where('member_id',$check)->first();
              $workerProfile = MemberProfile::where('member_id',$d->member_id)->first();

              $result[$key]['id'] = $d->id;
              $result[$key]['member_id'] = $d->member_id;
              $result[$key]['member_name'] = $profile->firstname . ' '. $profile->surname;
              $result[$key]['title'] = Outsource::getJobDetail($detail->job_id)->value;
              $result[$key]['about'] = $detail->about;
              $result[$key]['profile_photo'] = $detail->photo_link;
              $result[$key]['example_video_link'] = $story['video_link'];
              @$result[$key]['distance']=Outsource::haversineDistance($workerProfile->loc_lat,$workerProfile->loc_lng,$me->loc_lat,$me->loc_lng);
          }


          return response()->json(array('status'=>true,'message'=>'Çalışan listesi getirildi.','result'=>$result));
        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
  }
}
