<?php

namespace App\Http\Controllers;

use App\MemberCreditHistory;
use App\MembershipPlan;
use Illuminate\Http\Request;
use App\Outsource;

class MembershipController extends Controller
{
    public function getMembershipPlans(Request $request)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

        $list = MembershipPlan::where('status','1')->whereNull('deleted_at')->get();
        return response()->json(array('status'=>true,'message'=>'Üyelik paketleri listelenmiştir.','data'=>$list));

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function getMembershipPlan(Request $request,$planId)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

        $list = MembershipPlan::where('id',$planId)->first();
        return response()->json(array('status'=>true,'message'=>'Üyelik paket detayı listelenmiştir.','data'=>$list));

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function membershipCreditHistory(Request $request)
    {

        $token = $request->header('token');
        $check = Outsource::checkToken($token);
        if($check)
        {

          $list = MemberCreditHistory::where('employer_id',$check)->whereNull('deleted_at')->orderBy('id','desc')->get();

          $dataset = array();
          foreach($list as $key=>$li){
            $dataset[$key]['id']=$li['id'];
            $dataset[$key]['title']=$li['title'];
            $dataset[$key]['amount']=$li['amount'];
            $dataset[$key]['type']=$li['type'];
            $dataset[$key]['created_at']=date('d/m/Y',strtotime($li['created_at']));
          }
          return response()->json(array('status'=>true,'message'=>'Kredi Geçmişi listelenmiştir.','data'=>$dataset));

        }else{
          return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
        }
    }
}
