<?php

namespace App\Http\Controllers;

use App\Member;
use App\MemberCreditHistory;
use App\MemberProfile;
use Illuminate\Http\Request;
use App\Outsource;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Validator;

class ExpenseController extends Controller
{
    public function payForViewProfile(Request $request,$workerId)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
        // Geçmişte bu kişi alındı mı ?
        $checkHistory = MemberCreditHistory::where('employer_id',$check)->where('worker_id',$workerId)->count();
        if($checkHistory < 1)
        {
          $action = Outsource::expenseCredit($check,'view_profile',$workerId);
          if($action)
          {
            $worker_basic = Member::find($workerId)->first();
            //$worker_data = MemberProfile::where('member_id',$workerId)->first();
            return response()->json(array('status'=>true,'message'=>'Kişi bilgisini artık görebilirsiniz.','data'=>$worker_basic));
          }else{
            return response()->json(array('status'=>false,'message'=>'Sistem kredi harcama onayını alamadı, lütfen kredi bakiyenizi kontrol ediniz.'));
          }
        }else{
          $worker_data = MemberProfile::where('member_id',$workerId)->first();
          return response()->json(array('status'=>true,'message'=>'Kişi bilgisini daha önce satın aldınız.','data'=>$worker_data));
        }
      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }
}
