<?php

namespace App\Http\Controllers;

use App\Member;
use App\MemberProfile;
use App\Outsource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Symfony\Component\HttpFoundation\Response;

class AuthController extends Controller
{
    public function checkToken(Request $request)
    {
        $token = $request->header('token');
        $check = Outsource::checkToken($token);
        if ($check) {
            $profile = Member::find($check);
            $memprofile = MemberProfile::where('member_id', $check)->count();
            if ($memprofile > 0) {
                $goto = 'home';
            } else {
                $goto = 'profile';
            }
            return response()->json(array('status' => true, 'message' => 'Oturum doğrulama başarılı.', 'goto' => $goto, 'type' => $profile->type));
        } else {
            return response()->json(array('status' => false, 'message' => 'Lütfen, tekrar sisteme giriş yapınız.'));
        }
    }

    public function signup(Request $request)
    {

        $validator = Validator::make(
            $request->all(),
            [
                'type' => 'required',
                'name' => 'required',
                'email' => 'required',
                'password' => 'required',
                'phone' => 'required|unique:members',
            ],
            [
                'required' => '* Gerekli alan',
                'unique' => 'Telefon bilgisi daha önce kullanılmıştır, farklı telefon deneyiniz.',
                'email' => 'Lütfen, geçerli bir e-posta adresi belirtiniz.',
                'date' => 'Lütfen, geçerli bir tarih belirtiniz.'
            ]
        );

        if ($validator->fails()) {

            $errors = $validator->messages()->all();
            $error = array_shift($errors);


            $result = array('status' => false, 'message' => $error);

            return response()->json($result);
        } else {
            $date = date('Y-m-d H:i:s');
            $password = Hash::make($request->get('password'));
            $type = $request->get('type');
            $phone = $request->get('phone');
            // 1 Çalışan 2 İşveren
            if ($type == '1') {
                @$insert = DB::table('members')
                    ->insertGetId([
                        'type' => $type,
                        'firstname' => $request->get('name'),
                        'email' => $request->get('email'),
                        'password' => $password,
                        'phone' => $phone,
                        'lang' => 'tr',
                        'active' => '0',
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'created_at' => $date,
                    ]);
            } else {
                @$insert = DB::table('members')
                    ->insertGetId([
                        'type' => $type,
                        'company_title' => $request->get('company_title'),
                        'firstname' => $request->get('name'),
                        'email' => $request->get('email'),
                        'password' => $password,
                        'phone' => $phone,
                        'lang' => 'tr',
                        'active' => '0',
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'created_at' => $date
                    ]);
            }

            if ($insert) {
                $code = rand(10000, 99999);
                $insertOtp = DB::table('member_otps')
                    ->insert([
                        'member_id' => $insert,
                        'type' => '1',
                        'code' => $code,
                        'to' => $phone,
                        'created_at' => $date
                    ]);
                $msg = 'Doğrulama kodunuz: ' . $code . ' uygulamaya girerek kayıt işleminizi tamamlayabilirsiniz.';
                $sendSMS = Outsource::sendSingleSms($phone, $msg);
            }

            if ($sendSMS['err']) {
                $result = array('status' => false, 'message' => $sendSMS['err']['message'] . ' Doğrulama kodunuz gönderilemedi, lütfen Telefon numaranızı kontrol ediniz.');

                $delete = DB::table('members')->where('id', $insert)->delete();
            } else {
                $result = array('status' => true, 'message' => 'Kaydınız yapılmıştır, sonraki adıma yönlendiriliyorsunuz.');
            }

            return response()->json($result);
        }
    }

    public function login(Request $request)
    {
        $phone = $request->get('phone');
        $password = $request->get('password');

        if (Auth::guard('api')->attempt(['phone' => $phone, 'password' => $password, 'active' => '1'])) {
            $member = Auth::guard('api')->user();
            $type = $member->type;
            $token = base64_encode(Str::random(40));

            Member::where('phone', $phone)->update(['last_login_ip' => $_SERVER['REMOTE_ADDR'], 'token' => "$token", 'last_login' => date('Y-m-d H:i:s')]);
            Auth::guard('api')->login($member);

            $id = Outsource::checkToken($token);
            $checkProfile = DB::table('member_profiles')->where('member_id', $id)->count();

            if ($checkProfile > 0) {
                $profileGenerated = true;
            } else {
                $profileGenerated = false;
            }

            $result = array(
                "error" => false,
                "message" => "Başarıyla giriş yaptınız. Yönlendiriliyorsunuz..", "token" => $token, 'type' => $type, 'profileGenerated' => $profileGenerated
            );
        } else {
            $result = array(
                "error" => true,
                "message" => "Sistemde kayıtlı kullanıcı bulunamadı."
            );
        }

        return response()->json($result);
    }

    public function forgotPassword(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'phone' => 'required'
            ],
            [
                'required' => '* Gerekli alan'
            ]
        );

        if ($validator->fails()) {
            return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        } else {
            $phone = $request->get('phone');
            $date = date('Y-m-d H:i:s');
            $check = DB::table('members')->where('phone', $phone)->first();

            if (isset($check->id)) {
                $new_password = rand(100000, 999999);

                $update = DB::table('members')
                    ->where('id', $check->id)
                    ->update([
                        'password' => Hash::make($new_password),
                        'updated_at' => date('Y-m-d H:i:s')
                    ]);

                $msg = 'Şifreniz : ' . $new_password . ' olarak güncellenmiştir. Visivi Ekibi';
                $sendSMS = Outsource::sendSingleSms($phone, $msg);



                if ($sendSMS['err']) {
                    $result = array('status' => false, 'message' => 'Telefon numaranıza SMS gönderilememiştir, lütfen daha sonra tekrar deneyiniz.');
                } else {
                    $result = array('status' => true, 'message' => 'Yeni şifreniz hesabınızla eşli telefon numaranıza gönderilmiştir.');
                }
            } else {
                $result = array('status' => false, 'message' => 'Kayıtlı telefon numarası bulunamadı.');
            }


            return response()->json($result);
        }
    }

    public function checkProfile(Request $request)
    {

        $token = $request->header('token');
        $check = Outsource::checkToken($token);
        if ($check) {
        } else {

            return response()->json(array('status' => false, 'message' => 'Lütfen, tekrar sisteme giriş yapınız.'));
        }
    }

    public function newOtp(Request $request)
    {
        $phone = $request->get('phone');

        $date = date('Y-m-d H:i:s');
        $check = DB::table('member_otps')->where('to', $phone)->orderBy('id', 'desc')->first();

        if (isset($check->member_id)) {
            $code = rand(10000, 99999);
            $insertOtp = DB::table('member_otps')
                ->insert([
                    'member_id' => $check->member_id,
                    'type' => '1',
                    'code' => $code,
                    'to' => $phone,
                    'created_at' => $date
                ]);
            $msg = 'Doğrulama kodunuz: ' . $code . ' uygulamaya girerek kayıt işleminizi tamamlayabilirsiniz.';
            $sendSMS = Outsource::sendSingleSms($phone, $msg);

            $delete_before = DB::table('member_otps')->where('id', $check->id)->delete();

            $result = array('status' => true, 'message' => 'Doğrulama kodunuz gönderilmiştir.');
        } else {
            $result = array('status' => false, 'message' => 'İşlem sırasında hata oluştu, lütfen tekrar deneyiniz.');
        }

        return response()->json($result);
    }

    public function otpSubmit(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'code' => 'required'
            ],
            [
                'required' => '* Gerekli alan'
            ]
        );

        if ($validator->fails()) {
            return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        } else {
            $phone = $request->get('phone');
            $date = date('Y-m-d H:i:s');
            $check = DB::table('member_otps')->where('to', $phone)->orderBy('id', 'desc')->first();

            if ($check->code == $request->get('code')) {
                $updated = DB::table('members')->where('id', $check->member_id)->update(['active' => '1', 'updated_at' => $date]);
                $update = DB::table('member_otps')->where('id', $check->id)->update(['activated' => '1', 'updated_at' => $date]);

                $result = array('status' => true, 'message' => 'Hesabınızı başarıyla doğruladınız. Giriş yapmak için yönlendiriliyorsunuz.');
            } else {
                $result = array('status' => false, 'message' => 'Geçersiz kod girişi oldu, lütfen tekrar deneyiniz.');
            }

            return response()->json($result);
        }
    }
}
