<?php

namespace App\Http\Controllers;

use App\CJob;
use App\Member;
use Illuminate\Http\Request;
use App\Outsource;
use App\PostApplication;
use App\Postx;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Validator;

class ApplyController extends Controller
{
    public function setApply(Request $request)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);

      if($check)
      {
        $validator = Validator::make($request->all(),
        [
          'post_id' => 'required',
          'video_link' => 'required'
        ],[
          'required' => '* Gerekli alan'
        ]);

        if ($validator->fails()) {
          return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        }else{

          $request->request->add(['creator_id' => $check,'apply_ip'=>$_SERVER['REMOTE_ADDR']]);

          $postApplicationItemsCount = PostApplication::where('post_id',$request->get('post_id'))
                                ->where('creator_id',$check)
                                ->count();

          if(!$postApplicationItemsCount)
          {
              $input = $request->all();

              $update = PostApplication::insert($input);

              return response()->json(array('status'=>true,'message'=>'Başvurunuz başarıyla alınmıştır.'));
          }else{
              return response()->json(array('status'=>false,'message'=>'Daha önce bu ilana başvurunuz bulunmaktadır.'));
          }


        }


      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function listApplyEmployer(Request $request,$postId,$type)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);

      if($check)
      {

        $checkPost = Postx::where('id',$postId)->where('member_id',$check)->count();

        if($checkPost>0)
        {

          // type => approved - pending

          if($type=='approved')
          {
            $list = PostApplication::where('post_id',$postId)->where('status','1')->whereNull('deleted_at')->get();
          }elseif($type=='pending'){
            $list = PostApplication::where('post_id',$postId)->where('status','0')->whereNull('deleted_at')->get();
          }elseif($type=='all'){
            $list = PostApplication::where('post_id',$postId)->whereNull('deleted_at')->get();
          }


          return response()->json(array('status'=>true,'message'=>'İlanınıza ait başvurular listelenmiştir.','data'=>$list));
        }else{
          return response()->json(array('status'=>false,'message'=>'Bu ilan size ait değildir.'));
        }


      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function cancelApplyWorker(Request $request,$id)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

        $action = PostApplication::where('id',$id)->update(['deleted_at'=>date('Y-m-d H:i:s')]);
        return response()->json(array('status'=>true,'message'=>'İşleminiz başarıyla gerçekleşmiştir.'));

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function listApplyWorker(Request $request,$type)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

          // type => approved - pending

          if($type=='approved')
          {
            $list = PostApplication::where('creator_id',$check)->where('status','1')->whereNull('deleted_at')->get();
          }elseif($type=='pending'){
            $list = PostApplication::where('creator_id',$check)->where('status','0')->whereNull('deleted_at')->get();
          }elseif($type=='all'){
            $list = PostApplication::where('creator_id',$check)->whereNull('deleted_at')->get();
          }

          $result = array();
          foreach($list as $key=>$li)
          {
            $post_detail = Postx::find($li->post_id);
            $result[$key]['id']=$li->id;
            $result[$key]['post_id']=$li->post_id;
            $result[$key]['video_link'] = $li->video_link;
            $result[$key]['post_company'] = Member::find($post_detail->member_id)->company_title;
            $result[$key]['post_job'] = CJob::find($post_detail->job_id)->value;
            $result[$key]['apply_date'] = date('d.m.Y',strtotime($li->created_at));
            $result[$key]['approved_at']=$li->approved_at;
            $result[$key]['rejected_at']=$li->rejected_at;
          }


          return response()->json(array('status'=>true,'message'=>'Başvurduğunuz ilanlar listelenmiştir.','data'=>$result));

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }
}
